# -*- coding: utf-8 -*-

__module_name__ = "Azaziel Bot - Game Module"
__module_version__ = "0.42"
__module_description__ = "Jeux divers à Tirage"
__module_author__ = "ephem <ephem AT deepumbra DOT net>"

import xchat, string, random, time, datetime, types


users={}
bot_name = xchat.get_info("nick")
prefload = False
chan_list = []
chanswitch = []
opusers = []
party = []
scores = []
refus = []
chanpots = []
realnicks = []
pokerhook = None
jeu421hook = None
bjkhook = None
crapshook = None
rollhook = None

jeu_cmd_tab = [("poker", "pocker"), ("strip_poker", "strippoker", "strip"),("421", ), ("blackjack", "21", "bjk"), ("jackpot", "bandit_manchot", "jckpot"), ("craps", ), ("roulette", ),
               ("score", "myscore", "monscore"), ("casino", "jeualea"), ("bluff", "bluf"), ("newdeal", ), ("relance", ), ("carte", "cartes"),
               ("regles", "regle"), ("nick", "realnick"), ("refuse", "jeveuxpasjouer", "rejoue"), ("chgscore", "setscore"), ("commandes", "usage", "cmds", "commands", "aide", "cmd", "commande", "--help", bot_name.lower())]

regles_jeux_tab = [
    ("poker", "Chaque joueur reoit une main de 5 cartes. Le but du jeu est d'avoir la meilleure combinaison possible parmi, dans l'ordre :", 
     " Paire (deux figures identiques), Double Paire (deux paires), Brelan (trois figures identiques), Quinte (suite de 5 figures), Couleur (toutes les cartes d'une mme couleur), Full (un Brelan et une Paire), Carr (4 figures identiques) et Quinte Flush (une Quinte d'une seule couleur).", 
     " La quinte est dte Blanche si elle commence par l'As, Royale si elle termine par l'As. On peut changer jusqu' 4 cartes si la main ne nous satisfait pas (commande !newdeal)."), 
    ("421", "Le jeu consiste en Un  Trois lancers de 3 ds. Le but du jeu est d'avoir la meilleure combinaison possible parmi, dans l'ordre :", 
     "Nenette (221), Suite (3 chiffres qui se suivent, de 123  456), aux As (un chiffre et deux 1) et Tierce (3 ds identiques) successivement (211 < 222 < 311 < 333...), Tierce d'As (111) et 421", 
     "La Nenette est ganante si aucun advarsaire n'a fait de combinaison, perdante sinon. On peut changer jusqu' 3 ds si le jet ne nous satisfait pas, et ce 2 fois au plus (commande !relance)."),
    ("blackjack", "chaque joueur reoit deux cartes, l'une face cache. Le but du jeu est de se rapprocher le plus possible de 21 sans le dpasser ou faire 21 (black jack).",
     "Les cartes valent leur valeur sauf les figures (valet, dame, roi) qui valent 10 et l'As qui vaut 11 ou 1 selon (soft). Une fois toutes les cartes retournes, on additionne les valeurs des cartes. Le joueur qui dpasse 21 a perdu (bust)",
     "On peut demander autant de carte que l'on veut lors de la partie en utilisant la commande !carte"),
    ("jackpot", "Le Jackpot ou Bandit Manchot est un jeu de pur hasard, le but étant d'obtenir trois symboles identiques :", 
     "Les symboles 7, , $ et = permettent d'obtenir des gains plus importants (dans l'ordre x100, x25, x9 et x4), les vides sont perdants.",
     "Pour dcrocher le Jackpot, il faut obtenir trois 7 en ayant mis la valeur maximale, soit 5 jetons."),
    ("craps", "On lance deux ds, et on parie sur le rsultat de la combinaison des deux ds:",
     "On peut parier un field si la somme des ds vaut 2, 3, 4, 9, 10, 11 ou 12 (rapporte la mise sauf 2 et 12 qui rapportent 2 fois la mise), ou on peut simplement gagner si la somme des ds est gale au pari, 2 ou 12 rapportant 30 fois la mise, 3 ou 11 rapportant 15 fois la mise, 7 rapportant 4 fois la mise, 5 et 9 rapportant 1,5 fois la mise, 6 et 8 rapportant 1,2 fois la mise.",
     "On peut galement parier sur la sortie d'un craps (2, 3 ou 12) qui rapporte 7 fois la mise, d'un hard (deux ds identiques) qui rapporte 9 fois la mise pour hard6 ou hard8, 7 fois pour hard4 ou hard10,  d'un pass (7 ou 11) ou d'un don'tpass (les autres) qui rapportent la mise."),
    ("roulette", "Une bille est lance sur une roue comportant 37 numros de 0  36, et on parie sur le numro sur lequel la bille s'arrte:",
     "Les mises pleines (un seul numro) rapportent 35 fois la mise (sauf 0 qui rapporte 36 fois la mise). On peut galement parier  cheval sur deux numros (eg cheval1-4, 17 fois la mise), sur une transversale de 3 numros (eg transversale1-3, 11 fois la mise), sur un carr de 4 numros (eg carre1-5, 8 fois la mise), un sizain de 6 numros (eg sizain1-6, 5 fois la mise) ou une douzaine qui rapporte 2 fois la mise.",
     "On peut galement faire une mise simple, c'est  dire parier sur la couleur du numro (noir ou rouge), sa parit (pair ou impair) ou sa position, plus petit que 18 ou de 19  36 (manque ou passe), ce qui rapporte la mise. Le 0 ne rapporte que si le pari est 0 (vert, perte et seul le 0 gagne !!!)")
    ]

bluf_tab = (
    "%s se lance dans une partie endiable", "%s bluffe  donf", "%s se dmne comme un diable", "Beau coup de Bluf %s !!! :)", 
    "Les gouttes de sueur qui perlent le long du front de %s pourraient bien trahir son faible jeu", "%s hausse un sourcil  la donne...",
    "Servi au premier tour !!! Que tente donc %s ???"
    )
bluf_vs_tab = (
    "grce  cette magnifique feinte et %s n'y a vu que du feu !!!", "et cette ruse laisse %s tout pantois !"
    )
bluf_end_tab = (
    "mais %s ne s'y est pas laiss prendre et", "hlas %s voit venir le coup et"
    )

## Jeu de roulette

rouges = (1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36)
says = ("Faites vos Jeux !!!", "Les jeux sont faits !!!", "Rien ne va plus !!!")

def roulette(*var):
    global party
    global rollhook
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    for partie in party:
        if "roulette" in partie and chan in partie:
            return miseroulette(*var)
    tapis = []
    party.append(("roulette", tapis, chan))
    rollhook = xchat.hook_timer(15000, carryroll, userdata = ct)
    xchat.command("say La Roulette est lance !!! 4%s" % (says[0]))
    return miseroulette(*var)

def carryroll(userdata):
    global rollhook
    ct = userdata
    chan = channel_id(ct)
    chan_buf = ct.get_info("channel")
    xchat.unhook(rollhook)
    rollhook = None
    xchat.command("msg %s 4%s" % (chan_buf, says[1]))
    rollhook = xchat.hook_timer(15000, endroll, userdata = ct)
    return 2

def miseroulette(*var):
    global party
    paris = ("noir", "rouge", "pair", "impair", "passe", "manque")
    ct = xchat.get_context()
    chan = channel_id(ct)
    joueur = var[0]
    pot = 1
    pari2 = [0]
    if len(var) < 4: var += (pot, )
    if var[1] in paris: pari = var[1]
    elif is_integer(var[1]) and 0<=int(var[1])<37: pari = var[1]
    elif var[1].find("douzaine") == 0:
        pari = "douzaine"
        pari2 = var[1].split("douzaine")[1]
        pari2 = pari2.split("-")
        if len(pari2) == 0 or not is_integer(pari2[0]): pari2 = ["1", "12"]   ## pari par défaut des douzaines
        start = 1 + 12*int((int(pari2[0])-1)/12)
        if len(pari2) == 1: end = start + 11
        elif is_integer(pari2[1]):
            if int(pari2[1]) < start + 12: end = start + 11
            elif pari2[0] in ("1", "2", "3"):
                start = int(pari2[0])
                end = start + 33
            else: end = start + 11
        else: end = start + 11
        pari2 = [start, end]
    elif var[1].find("sizain") == 0 or var[1].find("transversale") == 0:
        if var[1].find("sizain") == 0: pari = "sizain"
        else: pari = "transversale"
        pari2 = var[1].split(pari)[1]
        pari2 = pari2.split("-")
        if len(pari2) == 0 or not is_integer(pari2[0]): pari2 = 1   ## pari par défaut des sizains et des transversales
        else: pari2 = 3*int((int(pari2[0])-1)/3)+1
        if pari == "sizain": pari2 = [pari2, pari2+5]
        else: pari2 = [pari2, pari2+2]
    elif var[1].find("carre") == 0:
        pari = "carre"
        pari2 = var[1].split("carre")[1]
        pari2 = pari2.split("-")
        if len(pari2) == 0 or not is_integer(pari2[0]): pari2 = 1   ## pari par défaut des carrés
        else: pari2 = int(pari2[0]) % 3 + 3*int((int(pari2[0])-1)/3)
        pari2 = [pari2, pari2+4]
    elif var[1].find("cheval") == 0 or var[1].find("-") == 1:
        pari = "cheval"
        if var[1].find("cheval") == 0: pari2 = var[1].split(pari)[1]
        else: pari2 = var[1]
        pari2 = pari2.split("-")
        if len(pari2) == 0 or not is_integer(pari2[0]): pari2 = ["1", "2"]   ## pari par défaut des mises à cheval
        if int(pari2[0]) < 36: start = int(pari2[0])
        else: start = 1
        if len(pari2) == 1: end = start + 1
        elif is_integer(pari2[1]):
            if int(pari2[1]) in (start + 1, start + 3): end = int(pari2[1])
            else: end = start + 1
        else: end = start + 1
        if start % 3 == 0: end = start + 3
        pari2 = [start, end]
    else: pari = str(random.randrange(0, 36))
    (pot, var) =  mise(1, *var)
    if pari in paris and pot > 200: pot = 200                             ## limite des mises
    elif pari == "douzaine" and pot > 100: pot = 100
    elif pari == "sizain" and pot > 60: pot = 60
    elif pari == "carre" and pot > 40: pot = 40
    elif pari == "transversale" and pot > 30: pot = 30
    elif pari == "cheval" and pot > 20: pot = 20
    elif is_integer(pari) and 0<int(pari)<37 and pot > 10: pot = 10
    for partie in party:
        if "roulette" in partie and chan in partie:
            tapis = partie[1]
            tapis.append((joueur, pari, pari2, pot))
            partie = ("roulette", tapis, chan)
            if pari2[0] != 0: buf_pari2 = "%s - %s" % (pari2[0], pari2[1])
            else: buf_pari2 = ""
            xchat.command("notice %s Ton pari a bien t pris en compte 4 %s jeton%s sur %s %s" % (joueur, pot, put_s(pot), pari, buf_pari2))
        else: xchat.command("say Aucune roulette en cours %s" % (joueur))
    return 1

def endroll(ct):
    global party
    global rollhook
    xchat.unhook(rollhook)
    rollhook = None
    chan = channel_id(ct)
    ct.command("say 4%s" % (says[2]))
    n = random.randrange(0, 36)
    ## couleur
    if n == 0:
        col = 8
        color = "vert"
    elif n in rouges:
        col = 4
        color = "rouge"
    else:
        col = 1
        color = "noir"
    ## parité
    if (n % 2) == 0 and n!= 0: par = "pair"
    elif n == 0: par = "perte"
    else: par = "impair"
    ## passe ou manque
    if n == 0: pasmank = "seul le 0 gagne !!!"
    elif n < 19: pasmank = "manque"
    else: pasmank = "passe"
    recap = ""
    for partie in party:
        if "roulette" in partie and chan in partie:
            tapis = partie[1]
            for tapi in tapis:
                joueur = tapi[0]
                pari = tapi[1]
                pari2 = tapi[2]
                pot = tapi[3]
                win = 0
                if (pari == color or pari == par or pari == pasmank): win = pot
                elif pari == "douzaine":
                    start = pari2[0]
                    end = pari2[1]
                    if end == start + 11:
                        if start <= n <= end: win = 2*pot
                        else: win = -pot
                    elif n % 3 == start: win = 2*pot
                elif pari == "sizain":
                    start = pari2[0]
                    end = start + 5
                    if start <= n <= end: win = 5*pot
                elif pari == "carre":
                    start = pari2[0]
                    end = start + 4
                    if start <= n <= end and n != start+2: win = 8*pot
                elif pari == "transversale":
                    start = pari2[0]
                    end = start + 2
                    if start <= n <= end: win = 11*pot
                elif pari == "cheval":
                    if n in pari2: win = 17*pot
                elif pari == str(n) and n != 0: win = pot*35
                elif pari == str(n): win = pot*36
                if pari2[0] != 0: buf_pari2 = "%s - %s" % (pari2[0], pari2[1])
                else: buf_pari2 = ""
                if win > 0: recap += "12* %s gagne %s jeton%s (3 %s %s12) *" % (joueur, win, put_s(win), pari, buf_pari2)
                else:
                    win = -pot
                    recap += "12* %s perd %s jeton%s (3 %s %s12) *" % (joueur, -win, put_s(win), pari, buf_pari2)
                if win != 0:
                    actsc = actlz_sc(joueur, win, ct)
                    botsc = actlz_sc(bot_name, -win, ct)
            party.remove(partie)
    ct.command("say 0,3|%s %s0 | %s, %s et %s  %s" % (col, n, color, par, pasmank, recap))
    return xchat.EAT_ALL

## Jeu de Jackpot (ou Bandit Manchot)

RNG = ((0, 22, 43, 63, 82), (1, 23, 44, 64, 83), (2, 24, 45, 65, 84), (3, 25, 46, 66), (4, 26, 47, 67, 85), (5, 27, 48, 68, 86), (6, 28, 49, 69, 87), (7, ), (8, 29, 50, 70, 88), (9, 30, 51, 71, 89), (10, 31, 52, 72, 90), (11, 32, 53, 73, 91), (12, 33, 54, 74, 92), (13, 34, 55, 75, 93), (14, 35, 56, 76, 94), (15, 36), (16, 37, 57, 77, 95), (17, 38, 58, 78, 96), (18, 39, 59, 79, 97), (19, 40, 60, 80, 98), (20, 41, 61, 81, 99), (21, 42, 62))
symbols = ("@", "=", "-", "7", "#", "&", "*", "", "", "", "$")

def jackpot(*var):
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    chanpot = chanpots[p]
    joueur = var[0]
    (pot, var) =  mise(1, *var)
    tirage = ()
    max = False
    buf = "1,1.4,8|"
    buf_win = "peut tre plus de chance la prochaine fois %s" % (joueur)
    if pot > 4:
        pot = 5
        max = True
    i = 0
    win = 1
    while i < 3:
        n = random.randint(0, 2147483584)
        ent = int(n/32)
        n = int((n*3.125-ent*100))
        for set in RNG:
            if n in set:
                if int(set[0]/2) in tirage and set[0] not in (2, 6, 14, 20):
                    win += 1
                    if set[0] == 7: pot = pot*10
                    elif set[0] == 15: pot = pot*5
                    elif set[0] == 21: pot = pot*3
                    elif set[0] == 3: pot = pot*2
                if set[0] in (2, 6, 14, 20): buf += "3,3 _ 4,8|" 
                else:
                    buf += "0,3 %s 4,8|" % (symbols[int(set[0]/2)])
                    tirage += (int(set[0]/2), )
        i += 1
    buf += "1,1."
    if win == 2:
        pot = 2*pot
        buf_win = "Deux symboles identiques, tu gagnes %s jeton%s" % (pot, put_s(pot))
    elif win == 3:
        pot = 3*pot
        buf_win = "Trois symboles identiques, tu gagnes %s jeton%s" % (pot, put_s(pot))
    else:
        botsc = actlz_sc(bot_name, pot-int(pot/2), ct)
        chanpot += int(pot/2)
        pot = -pot
    if win == 3  and tirage[0] == 3 and max == True:
        pot = chanpot
        chanpot = 1500
        buf_win = "Trois 7, tu dcroches le Jackpot !!!! :) %s jeton%s" % (pot, put_s(pot))
    actsc = actlz_sc(joueur, pot, ct)
    if win > 1: botsc = actlz_sc(bot_name, -pot, ct)
    chanpots[p] = chanpot
    xchat.command("say %s_| 10,8Jackpot 4 %s 10jeton%s - %s 12** %s %s jeton%s **" % (buf, chanpot, put_s(chanpot), buf_win, real_nick(joueur, ct), actsc, put_s(actsc)))
    raz_scores(ct)
    return xchat.EAT_ALL

## Jeu de Pocker

Cartes = (2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
Couleur = ["Carreau", "Coeur", "Trfle", "Pique"]
pioche = []

def fig(card):
    figures = ("Valet", "Dame", "Roi", "As")
    if card > 10: card = figures[card-11]
    return card

def paquet():
    jeu = []
    for col in Couleur:
        jeu.append([col, list(Cartes)])
    return jeu

def tirage(pioche, n):
    main = []
    i = 0
    while i < n:
        col = random.randrange(0, 4)
        dispo = pioche[col][1]
        l = len(dispo)
        while l == 0:
            col -= 1
            dispo = pioche[col][1]
            l = len(dispo)
        card = random.randrange(0, l)
        main.append((dispo[card], pioche[col][0]))
        dispo.remove(dispo[card])
        pioche[col][1] = dispo
        i += 1
    return main

def rules(main):
    score = 0
    cards = []
    type = ""
    for card in main: cards.append(card[0])
    cards.sort()
    ## Carré, Full, Brelan, paires et double paires
    two = False
    dnltwo = False
    three = False
    full = False
    four = False
    sep = "de "
    refcards = []
    for ref in Cartes:
        n = cards.count(ref)
        if ref == 14: sep = "d'"
        if n == 4:
            four = True
            type = "Carr %s%s%s" % (sep, fig(ref), iput_s(ref))
            score += 8
            refcards.append(ref)
        elif n == 3 and two == True:
            full = True
            type = "Full aux %s%s par les %s%s" % (fig(ref), iput_s(ref), fig(refcards[0]), iput_s(refcards[0]))
            score += 6
            refcards.append(ref)
            refcards.reverse()
        elif n == 3:
            three = True
            type = "Brelan %s%s%s" % (sep, fig(ref), iput_s(ref))
            score += 3
            refcards.append(ref)
        elif n == 2 and three == True:
            full = True
            type = "Full aux %s%s par les %s%s" % (fig(refcards[0]), iput_s(refcards[0]), fig(ref), iput_s(ref))
            score += 4
            refcards.append(ref)
        elif n == 2 and two == True: 
            dbltwo = True
            refcards.append(ref)
            refcards.sort()
            refcards.reverse()
            type = "Double paire %s%s%s par les %s%s" % (sep, fig(refcards[0]), iput_s(refcards[0]), fig(refcards[1]), iput_s(refcards[1]))
            score += 1
        elif n == 2: 
            two = True
            type = "Paire %s%s%s" % (sep, fig(ref), iput_s(ref))
            score += 1
            refcards.append(ref)
    ## flush (couleur)
    flush = True
    col = main[0][1]
    for card in main:
        if card[1] != col : flush = False
    if cards[4] == 14: sep = " l'"
    elif cards[4] == 12: sep = " la "
    else: sep = "au "
    if flush == True: 
        type = "Couleur  %s %s%s" % (col, sep, fig(cards[4]))
        score += 6
    ## Quinte (suite)
    quinte = True
    if cards[0] == 2 and cards[4] == 14: cards.insert(0, 1)
    i = 0
    while i < 4:
        if cards[i] != cards[i + 1] - 1: quinte = False
        i += 1
    if cards[4] == 14: sep = " l'"
    elif cards[4] == 12: sep = " la "
    else: sep = "au "
    sep2 = ""
    if flush == True : sep2 += " flush"
    if cards[0] == 1 :
        sep2 += " blanche"
        if quinte == False: cards.remove(1)
    if quinte == True: 
        type = "Quinte%s %s%s" % (sep2, sep, fig(cards[4]))
        if cards[0] == 1: score += 4
        else : score += 5
    if quinte == True and flush == True and cards[4] == 14:
        type = "Quinte flush royale  %s" % (col)
        score += 1
    if type == "":
        if cards[4] == 14: sep = "l'"
        elif cards[4] == 12: sep = "la "
        else: sep = "le "
        type = "Carte haute par %s%s" % (sep, fig(cards[4]))
    ## Les scores sont donc :HC 0, P 1, DP 2, B 3, QB 4, Q 5, Fl 6, F 7, C 8, QFlB 10, QFl 11, QFlR 12
        refcards.append(cards[4])
    return (score, type, refcards)

def comp_mains(pot, *mains):
    scores = []
    types = ()
    refcards = ()
    winners = []
    gain = pot * (len(mains)-1)
    for main in mains:
        (score, type, refcard) = rules(main)
        scores.append(score)
        types += (type, )
        refcards += (refcard, )
        gain += score
    highs = scores[:]
    highs.sort()
    high = highs[-1]
    i = 0
    while i < len(mains):
        if scores[i] == high: winners.append(i)
        i += 1
    while len(winners) > 1:
        p1 = winners[0]
        p2 = winners[1]
        n = comp_main(mains[p1], refcards[p1], mains[p2], refcards[p2])
        del winners[n]
    win = winners[0]
    return (win, gain, scores, types)

def comp_main(jeu1, refcards1, jeu2, refcards2):
    find = False
    los = 1
    i = 0
    if refcards1 == refcards2:
        jeu1.sort()
        jeu2.sort()
        while i < 5:
            if jeu1[4-i][0] < jeu2[4-i][0]: los = 0
            elif jeu1[4-i][0] > jeu2[4-i][0]: find = True
            i += 1
        if find == False and jeu1[4][1] < jeu2[4][1]: los = 0
    else:
        l = len(refcards1)
        while i < l:
            if refcards1[l-i-1] < refcards2[l-i-1]:
                los = 0
                break
            i +=1
    return los

def buf_main(main):
    buf = ""
    for card in main:
        if Couleur.index(card[1]) < 2 : col = 4
        else: col = 1
        buf += "| %s de %s%s0 |" % (fig(card[0]), col, card[1])
    return buf  

def pocker(*var):
    ct = xchat.get_context()
    pot = 1
    table = []
    (pot, var) =  mise(1, *var)
    pioche = paquet()
    for joueur in var:
        main = tirage(pioche, 5)
        table.extend([joueur, main])
        if joueur  != bot_name:
            xchat.command("notice %s 0,3 %s   %s" % (joueur, buf_main(main), rules(main)[1]))
            xchat.command("notice %s Pour une nouvelle donne taper !newdeal, ncartes (eg: !newdeal 1 4 pour remplacer la 1re et la 4me carte)" % (joueur))
    party.append(("poker", table, pioche, pot, ct))
    if bot_name in var: poker_bot(main)
##  Attente des joueurs
    pokerhook = xchat.hook_timer(30000, endpoker, userdata=ct)
    return 1

def strip(*var):
    ct = xchat.get_context()
    pot = 1
    table = []
    (pot, var) =  mise(1, *var)
    strip_var = ()
    for joueur in var: strip_var += (joueur + "_strip", )
    (pot, strip_var) = mise(10, *strip_var)
    pioche = paquet()
    for joueur in var:
        main = tirage(pioche, 5)
        table.extend([joueur + "_strip", main])
        if joueur  != bot_name:
            xchat.command("notice %s 0,3 %s   %s" % (joueur, buf_main(main), rules(main)[1]))
            xchat.command("notice %s Pour une nouvelle donne taper !newdeal, ncartes (eg: !newdeal 1 4 pour remplacer la 1re et la 4me carte)" % (joueur))
    party.append(("poker", table, pioche, pot, ct))
    if bot_name in var: poker_bot(main)
##  Attente des joueurs
    pokerhook = xchat.hook_timer(30000, endstrip, userdata=ct)
    return 1

def poker_bot(main):
    (score, type, refcards) = rules(main)
    bot_var = (bot_name, )
    if score < 4:
        i = 1
        for card in main:
            if card[0] not in refcards: bot_var += (i, )
            i += 1
    bot_var += (0, )
    newdeal(*bot_var)

def newdeal(*var):
    global party
    joueur = var[0]
    l = len(var)
    newcards = var[1:l-1]
    for partie in party:
        if "poker" in partie:
            i = 0
            table = partie[1]
            pioche = partie[2]
            if joueur in table or joueur + "_strip" in table:
                if joueur in table: main = table[table.index(joueur)+1]
                else: main = table[table.index(joueur + "_strip")+1]
                redone = tirage(pioche, len(newcards))
                while i < len(newcards) and i < 4:
                    main[int(newcards[i])-1] = redone[i]
                    i += 1
    return xchat.EAT_NONE

def endpoker(userdata):
    global pokerhook, party
    ct = userdata
    recap = ""
    mains = ()
    var = ()
    pot = 1
    table = []
    for partie in party:
        if "poker" in partie and ct in partie:
            pot = partie[3]
            table = partie[1]
            party.remove(partie)
            i = 0
            while i < len(table)/2:
                mains += (table[2*i+1], )
                var += (table[2*i], )
                i += 1
    winind = comp_mains(pot, *mains)
    winner = var[winind[0]]
    i = 0
    chan = ct.get_info("channel")
    while i < len(mains):
        if i != winind[0]: value = -winind[2][i]-pot
        else: value = winind[1]
        actsc = actlz_sc(var[i], value, ct)
        recap += "* %s %s jeton%s *" % (real_nick(var[i], ct), actsc, put_s(actsc))
        type = winind[3][i]
        xchat.command("msg %s %s 0,3 %s   %s" % (chan, var[i], buf_main(mains[i]), type))
        i += 1
    xchat.command("msg %s Bravo 4%s, tu as gagn 12%s jeton%s 14,14.%s14. 12*%s*" % (chan, winner, winind[1], put_s(winind[1]), buf_gain(winind[1]), recap))
    stop_hook(pokerhook)
    raz_scores(ct)
    return xchat.EAT_NONE

def endstrip(userdata):
    global pokerhook, party
    lims = (90, 80, 70, 60, 40, 20, 0)
    habits = ("la chaussure droite", "la chaussure gauche", "la chaussette droite", "la chaussette gauche", "son pantalon", "sa chemise", "ses sous vtements")
    ct = userdata
    recap = ""
    mains = ()
    var = ()
    pot = 1
    table = []
    for partie in party:
        if "poker" in partie and ct in partie:
            pot = partie[3]
            table = partie[1]
            party.remove(partie)
            i = 0
            while i < len(table)/2:
                mains += (table[2*i+1], )
                var += (table[2*i], )
                i += 1
    winind = comp_mains(pot, *mains)
    winner = var[winind[0]].split("_strip")[0]
    i = 0
    chan = ct.get_info("channel")
    while i < len(mains):
        if i != winind[0]: value = -winind[2][i]-pot
        else: value = winind[1]
        actsc = actlz_sc(var[i], value, ct)
        rest = "retire "
        if value < 0:
            n = int(-value/10)
            if n > 7: n = 7
            j = 0
            while lims[j] > actsc - value: j += 1
            while j < n-2:
                rest += habits[j] + ", "
                j += 1
            if j == n-2:
                rest += habits[j] + " et "
                j += 1
            if j == n - 1: rest += habits[j]
            if rest == "retire ": rest = "ne retire rien pour cette fois"
            recap += "* %s %s *" % (real_nick(var[i].split("_strip")[0], ct), rest)
        type = winind[3][i]
        xchat.command("msg %s %s 0,3 %s   %s" % (chan, var[i].split("_strip")[0], buf_main(mains[i]), type))
        if actsc < 0:
            friend = real_nick(var[i].split("_strip")[0], ct)
            while friend == real_nick(var[i].split("_strip")[0], ct): friend = random_nick()
            xchat.command("msg %s Brrr !!! 4%s doit avoir un peu froid et se rchauffe auprs de %s pour obtenir de nouveaux vtements :p" % (chan, real_nick(var[i].split("_strip")[0], ct), friend))
            actsc = actlz_sc(var[i], 100-actsc, ct)
        elif actsc > 100: actsc = actlz_sc(var[i], 100-actsc, ct)
        i += 1
    xchat.command("msg %s Bravo 4%s, tu es rhabill pour l'hiver :D 12*%s*" % (chan, winner, recap))
    stop_hook(pokerhook)
    raz_scores(ct)
    return xchat.EAT_ALL

## Jeu de Black Jack

def blackjack(*var):
    ct = xchat.get_context()
    pot = 1
    (pot, var) = mise(1, *var)
    pioche = paquet()
    table = []
    for joueur in var:
        main = tirage(pioche, 2)
        if joueur  != bot_name:
            xchat.command("notice %s 0,3 |14,14carte cache0,3|%s   %s" % (joueur, buf_main(main[1:]), rulesbjk(main[1:])))
            xchat.command("notice %s Pour une nouvelle carte taper !carte" % (joueur))
        else:
            while rulesbjk(main) < 17:
                main.extend(tirage(pioche, 1))
        table.extend([joueur, main])
    party.append(("blackjack", table, pioche, pot, ct))
    ## Attente des joueurs
    bjkhook = xchat.hook_timer(15000, endbjk, userdata=ct)
    return 3

def carte(*var):
    global party
    ct = xchat.get_context()
    joueur = var[0]
    n = 1
    if is_integer(var[1]): n = int(var[1])
    for partie in party:
        if "blackjack" in partie:
            table = partie[1]
            pioche = partie[2]
            if joueur in table:
                main = table[table.index(joueur)+1]
                main.extend(tirage(pioche, n))
                xchat.command("notice %s 0,3 |14,14carte cache0,3|%s   %s" % (joueur, buf_main(main[1:]), rulesbjk(main[1:])))
                xchat.command("notice %s Pour une nouvelle carte taper !carte" % (joueur))
    return xchat.EAT_ALL

def endbjk(userdata):
    pot = 1
    value = 0
    win = 0
    winners = ()
    players = ()
    table = []
    name = ""
    buf_table = ""
    buf_win = ""
    recap = ""
    k = 1
    for partie in party:
        if "blackjack" in partie:
            ct = partie[4]
            pot = partie[3]
            table = partie[1]
            party.remove(partie)
            chan = ct.get_info("channel")
    i = 0
    while i < len(table)/2:
        if win < rulesbjk(table[2*i+1]) < 22:
            winners = (table[2*i], )
            win = rulesbjk(table[2*i+1])
            if rulesbjk(table[2*i+1]) == 21 and len(table[2*i+1]) == 2:
                name = "*** Black Jack ***"
                k = 2
        elif rulesbjk(table[2*i+1]) == win: winners += (table[2*i], )
        players += (table[2*i], )
        buf_table += " %s (%s):0,3 %s" % (table[2*i], rulesbjk(table[2*i+1]), buf_main(table[2*i+1]))
        i +=1
    if len(winners) == 0:
        value = pot*(len(players)-1)
        winners = (bot_name, )
        buf_win = "Tous les joueurs en Bust, la Banque remporte la mise"
    elif len(winners) == 1:
        value = pot*(len(players)-1+k)
        buf_win = "Bien jou %s, tu as gagn %s jeton%s" % (winners[0], value, put_s(value))
    else:
        value = pot*(int(len(players)/len(winners))-1+k)
        buf_win = "Bravo "
        for winner in winners: buf_win += winner + ", "
        buf_win += "vous gagnez chacun %s jeton%s" % (value, put_s(value))
    for joueur in players:
        if joueur not in winners: actsc = actlz_sc(joueur, -pot, ct)
        else: actsc = actlz_sc(joueur, value, ct)
        recap += "* %s %s jeton%s *" % (real_nick(joueur, ct), actsc, put_s(actsc))
        i += 1
    xchat.command("msg %s %s 4%s %s" % (chan, buf_table, name, buf_win))
    xchat.command("msg %s 12*%s*" % (chan, recap))
    stop_hook(bjkhook)
    raz_scores(ct)
    return xchat.EAT_NONE

def rulesbjk(main):
    cmain = main[:]
    cmain.sort()
    sum = 0
    for card in cmain:
        if card[0] < 11: sum += int(card[0])
        elif card[0] == 14:
            if sum < 11: sum += 11
            else: sum += 1
        else: sum += 10
    return sum

## $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$  JEUX DE DES $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

def jet_des(n):
    i = 0
    jets = []
    while i < n:
        d = random.randrange(0, 6)+1
        jets.append(d)
        i += 1
    return jets

## Jeu de 421

def jeu421(*var):
    ct = xchat.get_context()
    pot = 0
    (pot, var) =  mise(0, *var)
    result = []
    for joueur in var:
        tirage = []
        main = jet(tirage, 0)
        main[0] += (joueur, )
        if joueur  != bot_name:
            xchat.command("notice %s 3,3.0 %s3. %s ** Pour relancer des ds, taper !relance, d(s)  relancer (eg: sur 431, !relance 3 pour relancer le 3, !relance tout ou !relance 4 3 1 pour tout relancer)" % (joueur, main[0][0], rules421([main[0]])[-1]))
        else:
            while rules421([main[0]])[2][0] == 1 and main[0][1] < 3:
                tirage = []
                main = jet(tirage, main[0][1])
                main[0] += (bot_name, )
        result.extend(main)
    party.append(("jeu421", result, pot, ct))
    ## Attente des joueurs
    jeu421hook = xchat.hook_timer(20000, end421, userdata=ct)
    return 1

def relance(*var):
    global party
    joueur = var[0]
    option = var[1]
    l = len(var)
    newdice = var[1:l-1]
    for partie in party:
        if "jeu421" in partie:
            table = partie[1]
            for main in table:
                if joueur in main:
                    lancer = main[1]
                    if lancer < 3:
                        if option == "tout": tirage = []
                        else:
                            n1 = main[0] % 10
                            n2 = (main[0] % 100 - n1)/10
                            n3 = int(main[0]/100)
                            tirage = [n1, n2, n3]
                            for dice in newdice:
                                if int(dice) in tirage: 
                                    tirage.remove(int(dice))
                        newjet = jet(tirage, lancer)
                        newjet[0] += (joueur, )
                        table.remove(main)
                        table.extend(newjet)
                    if lancer == 1: xchat.command("notice %s 3,3.0 %s3. %s ** Tu as encore droit  un lancer ( !relance d(s)  relancer)" % (joueur, newjet[0][0], rules421([newjet[0]])[-1]))
                    break
                else: None
        else: None
    return xchat.EAT_ALL

def end421(userdata):
    global party
    ct = userdata
    chan = ct.get_info("channel")
    tapis = ""
    recap = ""
    loos_buf = ""
    rmpt = False
    rmpt_buf = ""
    result = []
    for partie in party:
        if "jeu421" in partie and ct in partie:
            result = partie[1]
            pot = partie[2]
            party.remove(partie)
    (winners, loosers, gains, name) = rules421(result)
    while (len(loosers) > 1):
        rampot = []
        rmpt = True
        for looser in loosers:
            list = []
            main = jet(list, 2)
            main[0] += (looser, )
            rampot.extend(main)
        loosers = rules421(rampot)[1]
        rmpt_buf = "15,3| %s: %s || %s: %s |" % (rampot[0][2], rampot[0][0], rampot[1][2], rampot[1][0])
    perdant = loosers[0]
    winner = perdant
    while winner == perdant: winner = str(winners[random.randrange(0, len(winners))])
    for tirage in result:
        if perdant in tirage: pot += gains[result.index(tirage)]
    i = 0
    while i < len(result):
        value = 0
        tapis += "|1 %s:0 %s |" % (result[i][2], result[i][0])
        if result[i][2] == winner:
            value += pot + gains[i]
            winner += " !!! tu as gagn %s jeton%s 14,14.%s14." % (value, put_s(value), buf_gain(value))
        elif result[i][2] == perdant:
            for gain in gains: value -= gain
            value -= pot - gains[i]
            loos_buf += " %s perd %s jeton%s" % (perdant, int(-value), put_s(value))
            if rmpt == True: val_rmpt_buf = "Rampot pour %s jeton%s: " % (int(-value), put_s(value))
        else: value += gains[i]
        actsc = actlz_sc(result[i][2], value, ct)
        recap += "* %s %s jeton%s *" % (real_nick(result[i][2], ct), actsc, put_s(actsc))
        i += 1
    if (name != ""): name = "*** " + name + " ***"
    xchat.command("msg %s 0,3 %s  4%s Flicitations %s 14%s" % (chan, tapis, name, winner, loos_buf))
    if rmpt == True: xchat.command("msg %s %s%s" % (chan, val_rmpt_buf, rmpt_buf))
    xchat.command("msg %s 12*%s*" % (chan, recap))
    stop_hook(jeu421hook)
    raz_scores(ct)
    return xchat.EAT_NONE

def jet(tirage, lancer):
    n = len(tirage)
    tirage.extend(jet_des(3-n))
    tirage.sort()
    tirage.reverse()
    jet = int(tirage[0])*100+int(tirage[1])*10+int(tirage[2])
    lancer += 1
    jets = [(jet, lancer)]
    return jets

def rules421(jets):
    jets.sort()
    l = len(jets)
    gain = [0]*l
    pos = [17]*l
    winners = ()
    loosers = ()
    name = ""
    lowcombs = []
    comb = [(421, 10, "421"), (111, 7, "Tierce d'As"), (666, 6, "Tierce de 6"), (611, 6, "6 aux As"), (555, 5, "Tierce de 5"), (511, 5, "5 aux As"), 
            (444, 4, "Tierce de 4"), (411, 4, "4 aux As"), (333, 3, "Tierce de 3"), (311, 3, "3 aux As"), (222, 2, "Tierce de 2"), (211, 2, "2 aux As"), 
            (654, 2, "Grande Suite"), (543, 2, "Suite"), (432, 2, "Suite"), (321, 2, "Petite Suite"), (221, 4, "Nenette")]
    i = 0
    while (i < l):
        for set in comb:
            if (jets[i][0] in set):
                gain[i] = set[1]
                pos[i] = comb.index(set)
        if pos[i] == 17 : lowcombs.append(jets[i][0])
        i +=1
    highs = pos[:]
    highs.sort()
    high = highs[0]
    low = highs[-1]
    for set in comb:
        if jets[pos.index(high)][0] == set[0]: name = set[2]
    if (len(lowcombs) == l):
        j = l - lowcombs.index(lowcombs[l-1])
        while j > 0:
            gain[l-j] = 1
            winners += (jets[l-j][2], )
            j = j-1
    else:
        i = 0
        while i < l:
            if pos[i] == high: winners += (jets[i][2], )
            elif pos[i] == 16 : gain[i] = 0
            i += 1
    i = 0
    while i < l:
        if low == 17 and jets[i][0] == lowcombs[0]:
            loosers += (jets[i][2], )
        elif low < 17 and pos[i] == low:
            loosers += (jets[i][2], )
            if low == 16 and jets[i][2] != bot_name and high < 16: xchat.command("kick %s Tout bat Nenette %s :D (Nenette'Kick)" % (jets[i][2], jets[i][2]))
        i += 1
    return (winners, loosers, gain, name)

## Jeu de Craps

combs1 = ("big6", "big8", "4", "5", "6", "8", "9", "10", "win4", "win5", "win6", "win8", "win9", "win10")
combs2 = ("field", "7", "hard6", "hard8", "hard4", "hard10", "3", "2", "12", "11", "craps")
combs3 = ("come", "don'tcome")
combs4 = ("pass", "don'tpass", "don'tpassodds", "loose4", "loose5", "loose6", "loose8", "loose9", "loose10", "laybet4", "laybet5", "laybet6", "laybet8", "laybet9", "laybet10")

def craps(*var):
    global crapshook
    ct = xchat.get_context()
    chan = channel_id(ct)
    for partie in party:
        if "craps" in partie and chan in partie:
            return misecraps(*var)
    pot = 1
    point = 0
    if len(var) < 4: var += (pot, )
    if var[1] in combs1+combs2+combs4: pari = var[1]
    else: pari = "don'tpass"
    (pot, var) =  mise(1, *var)
    if pari in ("2", "12") and pot > 17: pot = 17
    elif pari in ("3", "11") and pot > 35: pot = 35
    elif pari in ("hard6", "hard8") and pot > 50: pot = 50
    elif pari in ("craps", "hard4", "hard10") and pot > 65: pot = 65
    elif pot > 500: pot = 500
    joueur = var[0]
    jet = jet_des(2)
    if jet[0] == jet[1]: type = "hard"
    else: type = "easy "
    value = jet[0]+jet[1]
    if value in (2, 3, 12): type = "craps"
    elif value == 7: type = "natural"
    elif value == 11: type = "pass"
    elif value in (5, 9): type = ""
    if pari in combs2+("big6", "big8"): win = rulescraps(value, type, pot, pari, point)
    elif value not in (4, 5, 6, 8, 9, 10): win = rulescraps(value, type, pot, pari, point)
    else: win = 0
    if win > 0: buf_win = "Félicitations %s, tu as gagné %s jeton%s (3 %s)" % (joueur, win, put_s(win), pari)
    elif win < 0: buf_win = "%s, tu perds %s jeton%s (3 %s)" % (joueur, str(-win), put_s(win), pari)
    else: buf_win = ""
    actsc = actlz_sc(joueur, win, ct)
    botsc = actlz_sc(bot_name, -win, ct)
    recap = "12* %s %s jeton%s *" % (real_nick(joueur, ct), actsc, put_s(actsc))
    buf_result = "0,3|%s|%s| 4%s %s - " % (jet[0], jet[1], type, value) 
    xchat.command("say %s %s %s" % (buf_result, buf_win, recap))
    if value in (4, 5, 6, 8, 9, 10):
        point = value
        if pari in combs1+combs4: tapis = [(joueur, pari, pot)]
        else: tapis = []
        party.append(("craps", point, tapis, chan))
        crapshook = xchat.hook_timer(30000, carrycraps, userdata=ct)
        return 1
    return xchat.EAT_ALL

def carrycraps(userdata):
    global party
    global crapshook
    ct = userdata
    chan = channel_id(ct)
    chan_buf = ct.get_info("channel")
    xchat.unhook(crapshook)
    crapshook = None
    for partie in party:
        if "craps" in partie and chan in partie:
            point = partie[1]
            tapis = partie[2]
            xchat.command("msg %s Craaaapssss !!! on lance pour le %s !" % (chan_buf, point))
            jet = jet_des(2)
            if jet[0] == jet[1]: type = "hard"
            else: type = "easy "
            value = jet[0]+jet[1]
            if value in (2, 3, 12): type = "craps"
            elif value == 7: type = "natural"
            elif value == 11: type = "pass"
            elif value in (5, 9): type = ""
            loose = "loose%s" % (value)
            laybet = "laybet%s" % (value)
            recap = ""
            removbet = ()
            chgbet = ()
            for paris in tapis:
                win = 0
                joueur = paris[0]
                pari = paris[1]
                pot = paris[2]
                if pari in combs2:
                    win = rulescraps(value, type, pot, pari, point)
                    removbet += (paris, )
                elif pari in combs1:
                    win = rulescraps(value, type, pot, pari, point)
                    if win > 0: removbet += (paris, )
                    else: win = 0
                elif pari in combs3 and value not in (7, point):
                    if pari == "come" and value in (4, 5, 6, 8, 9, 10): chgbet += ((joueur, value, pot), )
                    elif pari == "don'tcome" and value in (4, 5, 6, 8, 9, 10): chgbet += ((joueur, laybet, pot), )
                    else : win = -pot
                    removbet += (paris, )
                elif pari in combs4:
                    if pari in (loose, laybet):
                        removbet += (paris, )
                        win = -pot
                if win > 0: recap += "12* %s gagne %s jeton%s (3 %s12) *" % (joueur, win, put_s(win), pari)
                elif win < 0: recap += "12* %s perd %s jeton%s (3 %s12) *" % (joueur, -win, put_s(win), pari)
                if win != 0:
                    actsc = actlz_sc(joueur, win, ct)
                    botsc = actlz_sc(bot_name, -win, ct)
            for paris in removbet: tapis.remove(paris)
            for paris in chgbet: tapis.append(paris)
            partie = ("craps", point, tapis, chan)
            buf_result = "0,3|%s|%s| 4%s %s - " % (jet[0], jet[1], type, value)
            xchat.command("msg %s %s %s" % (chan_buf, buf_result, recap))
            if value in (7, point): return endcraps(value, type, ct)
            else:
                crapshook = xchat.hook_timer(30000, carrycraps, userdata=ct)
                return 1
    return xchat.EAT_ALL

def endcraps(value, type, ct):
    global party
    chan = channel_id(ct)
    chan_buf = ct.get_info("channel")
    for partie in party:
        if "craps" in partie and chan in partie:
            point = partie[1]
            tapis = partie[2]
            if value == point:
                buf_end = "Pass %s" % (point)
                point = 13
            else:
                buf_end = "Out Seven"
                point = 14
            recap = ""
            for paris in tapis:
                joueur = paris[0]
                pari = paris[1]
                pot = paris[2]
                win = rulescraps(value, type, pot, pari, point)
                if win > 0: recap += "12* %s gagne %s jeton%s (3 %s12) *" % (joueur, win, put_s(win), pari)
                elif win < 0: recap += "12* %s perd %s jeton%s (3 %s12) *" % (joueur, -win, put_s(win), pari)
                if win != 0:
                    actsc = actlz_sc(joueur, win, ct)
                    botsc = actlz_sc(bot_name, -win, ct)
            xchat.command("msg %s 4%s - On paye les mises du Craps !!! %s" % (chan_buf, buf_end, recap))
            party.remove(partie)
        return xchat.EAT_ALL

def misecraps(*var):
    global party
    ct = xchat.get_context()
    chan = channel_id(ct)
    pot = 1
    if len(var) < 4: var += (pot, )
    if var[1] in combs1+combs2+combs3+combs4: pari = var[1]
    else: pari = "don'tpassodd"
    if pari == "don'tpass": pari = "don'tpassodd"
    (pot, var) =  mise(1, *var)
    if pari in ("2", "12") and pot > 17: pot = 17
    elif pari in ("3", "11") and pot > 35: pot = 35
    elif pari in ("hard6", "hard8") and pot > 50: pot = 50
    elif pari in ("craps", "hard4", "hard10") and pot > 65: pot = 65
    elif pot > 500: pot = 500
    joueur = var[0]
    for partie in party:
        if "craps" in partie and chan in partie:
            point = partie[1]
            tapis = partie[2]
            tapis.append((joueur, pari, pot))
            partie = ("craps", point, tapis, chan)
            xchat.command("notice %s Ton pari a bien t pris en compte 4 %s jeton%s sur %s" % (joueur, pot, put_s(pot), pari))
        else: xchat.command("say Aucun craps en cours %s" % (joueur))
    return xchat.EAT_ALL
    
def rulescraps(value, type, pot, pari, point):
    big = "big%s" % (value)
    hard = "hard%s" % (value)
    win = "win%s" % (value)
    loose = "loose%s" % (value)
    looses = ("loose4", "loose5", "loose6", "loose8", "loose9", "loose10")
    laybet = "laybet%s" % (value)
    laybets = ("laybet4", "laybet5", "laybet6", "laybet8", "laybet9", "laybet10")
    if (((value in (7, 11) and point == 0) or point == 13) and pari == "pass") or (((value in (2, 3, 12) and point == 0) or (point == 14)) and (pari in ("don'tpass", "don'tpassodd"))):
        win = pot
        if pari == "don'tpassodd": win = int(win*0.665+0.5)
    elif (value in (3, 4, 9, 10, 11) and pari == "field") or (pari == big): win = pot
    elif pari in (hard, type) and type in ("hard", "craps"):
        if value in (6, 8): win = 9*pot
        else: win = 7*pot
    elif (value in (2, 12) and pari == "field"): win = 2*pot
    elif type == "craps" and pari == str(value):
        if value == 3: win = 15*pot
        else: win = 30*pot
    elif str(value) == pari and (point != 0 or value == 7):
        if value == 7: win = 4*pot
        elif value in (4, 10): win = 2*pot
        elif value in (5, 9): win = int(1.5*pot+0.5)
        else: win = int(1.2*pot+0.5)
    elif pari == win and point != 0:
        if value in (4, 10): win = int(1.8*pot+0.5)
        elif value in (5, 9): win = int(1.4*pot+0.5)
        else: win = int(7*pot/6+0.5)
    elif pari in looses and pari != loose and point > 12:
        if value in (4, 10): win = int(5*pot/11+0.5)
        elif value in (5, 9): win = int(5*pot/8+0.5)
        else: win = int(4*pot/5+0.5)
    elif pari in laybets and pari != laybet and point > 12:
        if value in (4, 10): win = int(0.95*pot/2+0.5)
        elif value in (5, 9): win = int(1.9*pot/3+0.5)
        else: win = int(0.95*5*pot/6+0.5)
    elif (pari == "come" and point == 14) or (pari == "don'tcome" and point == 13): win = pot
    else: win = -pot
    return win

## Initialisation

def channel_id(ct):
    return (ct.get_info("network") or ct.get_info("server")) + "@" + ct.get_info("channel")

def initswitch(word, word_eol, userdata):
    global chan_list
    global chanswitch
    global opusers
    global prefload
    ct = xchat.get_context()
    chan = channel_id(ct)
    oplist = Ops(chan, ct)
    if prefload != True: prefload = loadprefs(None)
    if chan not in chan_list:
        chan_list.append(chan)
        chanswitch.append("on")
        opusers.append(oplist)
        scores.append([bot_name, 100])
        chanpots.append(1500)
        realnicks.append({})
        refus.append([])
    return Jeu(word, word_eol, userdata)

prefhook = None

def loadprefs(userdata):
    global chan_list
    global chanswitch
    global opusers
    global scores
    global chanpots
    xchat.unhook(prefhook)
    try: prefs = open('Plugins/module42/module42prefs.txt', 'r')
    except: prefs = open('module42prefs.txt', 'r')
    lignes = prefs.readlines()
##    ligne = 0
##    while ligne < len(lignes):
##        xchat.prnt("Ligne %s chargée...%s" % (ligne, lignes[ligne].split()))
##        preflines[ligne] = lignes[ligne].split()
##        ligne += 1
    if len(lignes) > 0:
        chan_list = lignes[0].split()
        chanswitch = lignes[1].split()
        tup = ()
        for word in lignes[2].split():
            if word == "~tuple":
                opusers.append(tup)
                tup = ()
            else: tup += (word, )
        list = []
        for word in lignes[3].split():
            if word == "~list":
                scores.append(list)
                list = []
            else:
                if is_integer(word) and word != "0": list.append(int(word))
                else: list.append(word)
        for word in lignes[4].split():
            chanpots.append(int(word))
            realnicks.append({})
            refus.append([])
    prefs.close()
    xchat.prnt("scores chargés...")
    return True

def endswitch(userdata):
    preflines = [chan_list, chanswitch, opusers, scores, chanpots]
    l = len(preflines)
    prefs = open('Plugins/module42/module42prefs.txt', 'w')
    ligne = 0
    while ligne < l:
        buf = ""
        for elems in preflines[ligne]:
            if type(elems) == types.TupleType:
                for word in elems:
                    buf += str(word)+" "
                buf += " ~tuple "
            elif type(elems) == types.ListType:
                for word in elems:
                    buf += str(word)+" "
                buf += " ~list "
            else:
                buf += str(elems)+" "
        buf += "\n"
        prefs.write(buf)
        ligne += 1
    prefs.close()
    for chan in chan_list:
        chan = chan.split("%s@" % xchat.get_info('network'))[1]
        ct = xchat.find_context(channel=chan)
        if ct != None:
            ct.command("CLEAR")
            ct.prnt("Clear Window...")
    xchat.prnt("Autosaving scores...")
    return 1

xchat.hook_unload(endswitch)
xchat.hook_timer(3600000, endswitch)

def Ops(chan, ct):
    chanusers = ct.get_list("users")
    oplist = ()
    for user in chanusers:
        if  (user.prefix == '@' or user.prefix == '%'):
            oplist += (user.nick, )
    return oplist

def power(user, cmd, option):
    global opusers
    owner = [bot_name,"tusbar", "ephem"]
    state = ["on", "off"]
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    switch = chanswitch[p]
    opusers[p] = Ops(chan, ct)
    if (user in owner) and (cmd == "reload"):
        xchat.command("py reload fantasy.py")
    elif ((user in owner) or (user in opusers[p])) and (cmd in state) and option not in ("fantasy", "monopoly"):
        switch = state[state.index(switch)-1]
        chanswitch[p] = switch
        xchat.command("say Jeux rgls sur %s" % (switch))
    return xchat.EAT_NONE

## fonctionnement

def usage(nick, user, option):
    xchat.command("notice %s Commandes des Jeux %s :" % (user, bot_name))
    buf_tab = ()
    for elem in jeu_cmd_tab:
        buf_tab += (elem[0], )
    q = len(buf_tab) / 42
    r = len(buf_tab) % 42
    n = 1
    while (n <= q):
        buf_list = ""
        for elem in buf_tab[(n-1)*42:n*42]:
            buf_list += " !" + elem + " "
        xchat.command("notice %s %s" % (user, buf_list))
        n += 1
    buf_list = ""
    for elem in buf_tab[q*42:q*42+r]:
        buf_list += " !" + elem + " "
    xchat.command("notice %s %s" % (user, buf_list))
    return xchat.EAT_NONE

def act(l, *var):
    global list_jeux
    list_jeux = (pocker, strip, jeu421, blackjack, jackpot, craps, roulette)
    funct = list_jeux + (myscore, casino, bluff, newdeal, relance, carte)+(regles, nick, refuse, chgsc, usage)
    action = funct[l]
    return apply(action, var)

def strip_format(mot):
    while mot[:1] in ("\x02", "\x1f", "\x16", "\x03"):
        if mot[:1] == "\x03":
            mot = mot[3:]
            if mot[0] == ",": mot = mot[3:]
        else: mot = mot[1:]
    if mot[-1] == "\x0f": mot = mot[:-1]
    return mot

def refuse(*var):
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    joueur = real_nick(var[0], ct)
    refus_chan = refus[p]
    if joueur in refus_chan:
        refus_chan.remove(joueur)
        xchat.command("notice %s %s, tu peux de nouveau jouer sur %s" % (var[0], joueur, chan))
    else:
        refus_chan.append(joueur)
        xchat.command("notice %s %s, tu ne participe plus aux jeux sur %s" % (var[0], joueur, chan))
    refus[p] = refus_chan
    return xchat.EAT_ALL

def nick(*var):
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    realnick = realnicks[p]
    joueur = var[0]
    pseudo = var[1]
    realnick[joueur] = pseudo
    realnicks[p] = realnick
    xchat.command("notice %s Votre nick de jeu est maintenant %s" % (joueur, pseudo))
    return xchat.EAT_NONE

def chg_nick(word, word_eol, userdata):
    ct = xchat.get_context()
    chan = channel_id(ct)
    if (chan not in chan_list): initswitch(word, word_eol, userdata)
    p = chan_list.index(chan)
    realnick = realnicks[p]
    pseudo = word[0]
    joueur = word[1]
    list = realnick.keys()
    realnick[joueur] = pseudo
    if pseudo in list:
        if realnick[pseudo] != joueur:
            realnick[joueur] = realnick[pseudo]
        else: del realnick[joueur]
        del realnick[pseudo]
    realnicks[p] = realnick
    xchat.command("notice %s J'ai vu votre changement de pseudo, votre nick de jeu reste %s" % (joueur, real_nick(joueur, ct)))
    return xchat.EAT_NONE

xchat.hook_print("Change Nick", chg_nick)

def real_nick(joueur, ct):
    chan = channel_id(ct)
    p = chan_list.index(chan)
    realnick = realnicks[p]
    list = realnick.keys()
    if joueur in list: pseudo = realnick[joueur]
    else: pseudo = joueur
    return pseudo

def random_nick():
    list = xchat.get_list("users")
    i = random.randrange(0, len(list))
    return (list[i].nick)

def is_integer(n):
    try: int(str(n))
    except: return False
    else: return True

def put_s(n):
    if (n in (-1, 0, 1)): return ""
    else: return "s"

def iput_s(n):
    if (n in (11, 12, 13)): return "s"
    else: return ""


def stop_hook(the_hook): 
    if the_hook is not None: 
        xchat.unhook(the_hook) 
        the_hook = None
        xchat.prnt("%s stoppé" % (the_hook))

def mise(def_mise, *var):
    global scores
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    list = ct.get_list("users")
    users = ()
    for user in list: users += (user.nick, user.nick + "_strip")
    chnsc = scores[p]
    gain = def_mise
    actsc = ()
    option = var[-1]
    user = var[0]
    nick = var[1]
    if real_nick(user, ct) in refus[p]:
        xchat.command("notice %s %s, tu ne peux pas jouer %s, tape !rejoue pour rejouer !!!" % (user, real_nick(user, ct), chan))
        return xchat.EAT_ALL
    if (is_integer(option) and int(option) > 0): gain = int(option)
    if (nick == user or is_integer(nick)): var = (user, bot_name) + var[2:]
    i = 0
    while i < len(var)-1:
        if var[i] in (var[:i] + var[i+1:]) or (var[i] not in users) or (real_nick(var[i], ct) in refus[p]): 
            var = var[:i] + var[i+1:]
        i+=1
    if var[len(var)-2] not in users or (real_nick(var[len(var)-2], ct) in refus[p]): var = var[:len(var)-2]
    if var[len(var)-1] not in users or (real_nick(var[len(var)-1], ct) in refus[p]): var = var[:len(var)-1]
    if var == (user, ): var += (bot_name, )
    for joueur in var:
        if (real_nick(joueur, ct) not in chnsc and not is_integer(joueur)): chnsc.extend([real_nick(joueur, ct), 100])
        if (real_nick(joueur, ct) in chnsc): actsc += (chnsc[chnsc.index(real_nick(joueur, ct))+1], )
    if (0 < actsc[0] < gain and type(option) != list): gain = actsc[0]
    elif (type(option) == list): gain = option[1]
    elif (int(actsc[0]) < 1) : gain = def_mise
    return (gain, var)

def actlz_sc(joueur, gain, ct):
    global scores
    chan = channel_id(ct)
    p = chan_list.index(chan)
    chnsc = scores[p]
    actsc = int(chnsc[chnsc.index(real_nick(joueur, ct))+1]) + gain
    if (-100 < actsc < -90):
        ct.command("notice %s 1,1.4/!\ %s /!\1. tu risques la Banqueroute !!!" % (joueur, joueur))
    elif (actsc < -100):
        if joueur in opusers[p]:
            ct.command("say 1,1.4/!\ Banqueroute /!\1. ta dette est efface %s (Op Powa!!!)" % (joueur))
        else:
            ct.command("kick %s  1,1.4/!\ Banqueroute /!\1. %s est jet(e) hors du Casino sans mnagement :x" % (joueur, joueur))
        actsc = 100
    if actsc == 0: actsc = "0"
    chnsc[chnsc.index(real_nick(joueur, ct))+1] = actsc
    return actsc

def raz_scores(ct):
    chan = channel_id(ct)
    p = chan_list.index(chan)
    chnsc = scores[p]
    i = 0
    while i < len(chnsc)/2:
        if int(chnsc[2*i+1]) > 100000000:
            chan_buf = ct.get_info("channel")
            xchat.command("msg %s 1,1.4/!\ Banqueroute /!\1. Scores rinitialiss" % (chan_buf))
            highs = chnsc[:]
            highs.sort()
            high = highs[len(highs)/2-1]
            xchat.command("msg %s Meilleur score: %s avec %s jetons" % (chan_buf, chnsc[chnsc.index(high)-1], high))
            scores[p] = [bot_name, 100]
        i += 1
    return xchat.EAT_NONE

def buf_gain(gain):
    buf = ""
    i = 0
    if gain < 0:
        gain = - gain
        buf += "0- "
    ## non official tokens
    nbc = int(gain/10000000) ## bleu clair = 10 000 000 €
    gain -= nbc*10000000
    nvc = int(gain/2000000)  ## vert clair = 2 000 000 €
    gain -= nvc*2000000
    nm = int(gain/500000)    ## marron = 500 000 €
    gain -= nm*500000
    nvd = int(gain/100000)   ## vert d'eau = 100 000 €
    gain -= nvd*100000
    nvt = int(gain/25000)    ## violet = 25 000 €
    gain -= nvt*25000
    no = int(gain/5000)      ## orange = 5 000 €
    gain -= no*5000
    nj = int(gain/1000)      ## jaune = 1 000 €
    gain -= nj*1000
    ## official tokens
    nn = int(gain/100)       ## noir = 100 €
    gain -= nn*100
    nv = int(gain/25)        ## vert = 25 €
    gain -= nv*25
    nb = int(gain/10)        ## bleu = 10 €
    gain -= nb*10
    nr = int(gain/5)         ## rouge = 5 €
    gain -= nr*5
    nw = gain                ## blanc = 1 €
##    xchat.prnt("%s %s %s %s %s %s %s %s %s %s %s %s" % (nbc, nvc, nm, nvd, nvt, no, nj, nn, nv, nb, nr, nw))
    for n in (nbc, nvc, nm, nvd, nvt, no, nj, nn, nv, nb, nr, nw):
        j = 0
        col = (11, 13, 5, 10, 6, 7,  8, 1, 9, 12, 4, 0)[i]
        while j < n:
            j +=1
            buf += "%s@" % (col)
        i+=1
    return buf

def myscore(*var):
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    chnsc = scores[p]
##    xchat.prnt("%s" % (chnsc, ))
    if var[1] in ("all", "*"):
        list = xchat.get_list("users")
        var = var[:1]
        for user in list:
            if user.nick != var[0]: var+= (user.nick, )
    elif var[1] == "canal":
        var = var[:1]
        i = 0
        while i < len(chnsc)/2:
            if chnsc[2*i] != var[0]: var += (chnsc[2*i], )
            i += 1
    if var[0] == var[1]: var = var[1:]
    buf = "Score actuel sur le canal %s : " % (chan)
    i = 0
    for joueur in var :
        if real_nick(joueur, ct) in chnsc:
            score = int(chnsc[chnsc.index(real_nick(joueur, ct)) + 1])
            buf += "%s 12%s jeton%s 14,14.%s14. " % (joueur, score, put_s(score), buf_gain(score))
            i += 1
            if i > 6:
                xchat.command("notice %s %s" % (var[0], buf))
                buf = ""
                i = 0
    if buf != "": xchat.command("notice %s %s" % (var[0], buf))
    if real_nick(var[0], ct) not in chnsc : xchat.command("notice %s Tu n'as pas encore de score sur le canal %s" % (var[0], chan))
    return xchat.EAT_ALL

def chgsc(*var):
##    global scores
    user = var[0]
    ct = xchat.get_context()
    chan = channel_id(ct)
    p = chan_list.index(chan)
    list = ct.get_list("users")
    chnsc = scores[p]
    owner = ("ephem", "tusbar")
    if user in owner:
        var = var[1:]
        if var[0] in ("all", "canal", "*"):
            value = var[1]
            scores[p] = [bot_name, 100]
            for joueur in list:
                if joueur.nick != bot_name: scores[p].extend([joueur.nick, int(value)])
        elif var[0] in ("remove", "rmv"):
            if var[1] in chnsc:
                k = chnsc.index(var[1])
                del chnsc[k:k+1]
        else:
            l = int(len(var)/2)
            i = 0
            while i < l:
                value = int(var[2*i+1])
                if value == 0: value = "0"
                if var[2*i] not in chnsc:
                    chnsc.extend([var[2*i], value])
                else : chnsc[chnsc.index(var[2*i])+1] = value
                i += 1
        xchat.command("notice %s Scores modifiés" % (user))
    else: xchat.command("notice %s La maison ne fait pas crdit" % (user))
    return xchat.EAT_ALL

def bluff(*var):
    ct = xchat.get_context()
    p = chan_list.index(chan)
    realnick = realnicks[p]
    user = var[0]
    nick = var[1]
    buf = ""
    n = random.randrange(-len(bluf_tab), len(bluf_tab))
    if nick == bot_name:
        xchat.command("say On ne bluffe pas la banque, le croupier t'as à l'oeil maintenant %s" % (user))
        n = int(n/2)
        nick = user
    adv = nick
    if nick == user or real_nick(adv, ct) in refus[p]:
        while adv == bot_name or adv == user or real_nick(adv, ct) in refus[p]: adv = random_nick()
    if n > 0 : buf += "tu gagnes %s jeton%s %s" % (n, put_s(n), bluf_vs_tab[0] % adv)
    elif n < 0: buf += "%s tu perds %s jeton%s sur ce mauvais coup" % (bluf_end_tab[0] % adv, int(-n), put_s(n))
    else: buf += "mais il triche et le croupier s'en est rendu compte !!! %s est jett hors du casino sans mnagement" % (user)
    xchat.command("say %s ... %s" % (bluf_tab[n] % (user), buf))
    if n == 0: xchat.command("kick %s ... Dehors les Tricheurs !!!" % (user))
    v = mise(n, *(user, adv))
    act = actlz_sc(user, n, ct)
    act = actlz_sc(adv, -n, ct)
    return xchat.EAT_NONE

def regles(*var):
    user = var[0]
    jeu = var[1]
    if user == jeu: xchat.command("notice %s usage : !regles +jeu (eg: !regles 421 pour les rgles du 421)" % (user,))
    else:
        for (game, buf1, buf2, buf3) in regles_jeux_tab:
            if jeu == game:
                xchat.command("notice %s Rgles du %s :" % (user, game))
                xchat.command("notice %s %s" % (user, buf1))
                xchat.command("notice %s %s" % (user, buf2))
                xchat.command("notice %s %s" % (user, buf3))
    return xchat.EAT_ALL

def casino(*var):
    global list_jeux
    m = random.randrange(0, len(list_jeux))
    return act(m, *var)

## Appel du Jeu

def Jeu(word, word_eol, userdata):
    global chan_list
    global chanswitch
    ct = xchat.get_context()
    chan = channel_id(ct)
    if (chan not in chan_list):
        return initswitch(word, word_eol, userdata)
    if word[3] == ":": return xchat.EAT_NONE
    elif (strip_format(word[3][1:]).find("!") == 0):
        p = chan_list.index(chan)
        switch = chanswitch[p]
        l = len(word)-4
        cmd = strip_format(word[3][1:])[1:].lower()
        user = word[0].split("!")[0][1:]
        if l > 1: option = word[5]
        else: option = 0
        if ((switch == "off") and (cmd == "on") and l > 0) or (cmd == "reload"):
            if word[4] == bot_name: return  power(user, cmd, option)
        elif (switch == "off"): return xchat.EAT_NONE
        elif (switch == "on" and cmd == "off" and l > 0):
            if word[4] == bot_name: return power(user, cmd, option)
        elif (switch == "on"):
            for list in jeu_cmd_tab:    
                if cmd in list:
                    pos = jeu_cmd_tab.index(list)
                    if l == 0: var = (user, user, l)   
                    else:
                        if is_integer(word[l+3]): option = word[l+3]
                        elif l > 4 : option = word[8]
                        else : option = 0
                        i = 1
                        var = (user, )
                        lim = 5
                        if cmd in ("chgscore", "setscore"): lim = len(word)
                        while i < lim and i < l+1:
                            var += (word[i+3], )
                            i += 1
                        var += (option, )
                    return act(pos, *var)
            return xchat.EAT_NONE
        return xchat.EAT_NONE
    return xchat.EAT_ALL

chrset = ("à:", "â:", "ä:", "é:", "è:", "ê:", "ë:", "î:", "ï:", "ô:", "ù:", "û:", "ç:", "°:", "ø:", "€:", "«:", "»:")

print __module_name__, __module_version__, "loaded"
prefhook = xchat.hook_timer(17640,loadprefs)
xchat.hook_server("PRIVMSG", Jeu)
